import { ControlBase, MainControlProps, MainControlState } from '@core';

/**
 * @description 实体部件
 * @export
 * @class MainControl
 * @extends {ControlBase}
 */
export class MainControl extends ControlBase {

  /**
   * @description 部件状态
   * @type {MainControlState}
   * @memberof MainControl
   */
  public declare state: MainControlState;

  /**
   * @memberof MainControl
   */
  public setState() {
    super.setState();
    this.state.showBusyIndicator = toRef(this.props, 'showBusyIndicator') as any;
    this.state.controlAction = toRef(this.props, 'controlAction') as any;
  }

  /**
   * @description 安装部件所有功能模块的方法
   * @return {*} 
   * @memberof MainControl
   */
  public moduleInstall() {
    const superParams = super.moduleInstall();
    return {
      ...superParams
    };
  }
}
